<?php

namespace App\Models;

use CodeIgniter\Model;

class ProjectModel extends Model
{
    protected $table            = 'projects';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'nama_project', 'jenis_project', 'teknologi', 'tahun',
        'deskripsi', 'link_project', 'foto', 'urutan', 'created_at', 'updated_at'
    ];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function searchAndFilter($search = '', $filter = [], $sort = 'urutan', $order = 'ASC')
    {
        $builder = $this->builder();

        if (!empty($search)) {
            $builder->groupStart()
                ->like('nama_project', $search)
                ->orLike('teknologi', $search)
                ->orLike('deskripsi', $search)
                ->groupEnd();
        }

        if (!empty($filter['jenis_project'])) {
            $builder->where('jenis_project', $filter['jenis_project']);
        }

        if (!empty($filter['tahun'])) {
            $builder->where('tahun', $filter['tahun']);
        }

        $allowedSorts = ['urutan', 'nama_project', 'jenis_project', 'tahun', 'created_at'];
        $sort = in_array($sort, $allowedSorts) ? $sort : 'urutan';
        $order = strtoupper($order) === 'DESC' ? 'DESC' : 'ASC';

        $builder->orderBy($sort, $order);

        return $builder;
    }
}


